
byte GLOBAL_FLAG = 0;




#define PWM_MAX (128)
#define N_PWM (8)

byte PWM_VALUES[N_PWM];


// 53kHz kHz

//https://ww1.microchip.com/downloads/en/Appnotes/TB3214-Getting-Started-with-TCB-DS90003214.pdf
//

void setupTimer()
{
  // setup
  uint8_t ctrla = 0x00;
  //TCB0.CTRLA = 0x00; // turn off timer(if not known to be 0)
  
  ctrla = TCB_CLKSEL_CLKDIV2_gc | TCB_ENABLE_bm;
  TCB0.CCMP = 0x008f;
  TCB0.CTRLA=ctrla;  //only after assigning T to CCMP do we write to CTRLA to turn it on. 
  TCB0.INTCTRL = TCB_CAPT_bm;
  // end setup 
}




#define OUT1 (0b00010000)
#define OUT2 (0b00100000)
#define OUT3 (0b01000000)
#define OUT4 (0b10000000)
#define OUT5 (0b00100000)
#define OUT6 (0b00010000)
#define OUT7 (0b00001000)
#define OUT8 (0b00000100)


// the specific bit mask used to toggle a port pin,
// disable PWM on a pin by setting the corresponding pinMap to zero
//

const byte pinTemplates[8] = {OUT1, OUT2, OUT3, OUT4, OUT5, OUT6, OUT7, OUT8};
byte pinMaps[8] = {OUT1, OUT2, OUT3, OUT4, OUT5, OUT6, OUT7, OUT8};


// Maintain the PWMs
// 
ISR(TCB0_INT_vect) {
  
  static byte pwm_count = 0;

  pwm_count--;
  if(pwm_count == 0)
  {
    pwm_count = 128;
    // all off   
    //
    PORTA.OUTCLR = (pinMaps[0] | pinMaps[1] | pinMaps[2] | pinMaps[3] | pinMaps[6] |pinMaps[7]);
    PORTB.OUTCLR = (pinMaps[4] | pinMaps[5]);
     
  }
  
  if (PWM_VALUES[0] == pwm_count)
  {
    // turn on    
    PORTA.OUTSET = pinMaps[0];
  }
  if (PWM_VALUES[1] == pwm_count)
  {
    // turn on
    PORTA.OUTSET = pinMaps[1];
  }
  if (PWM_VALUES[2] == pwm_count)
  {
    // turn on
    PORTA.OUTSET = pinMaps[2];
  }
  if (PWM_VALUES[3] == pwm_count)
  {
    // turn on
    PORTA.OUTSET = pinMaps[3];
  }
  if (PWM_VALUES[4] == pwm_count)
  {
    // turn on
    PORTB.OUTSET = pinMaps[4];
  }
  if (PWM_VALUES[5] == pwm_count)
  {
    // turn on
    PORTB.OUTSET = pinMaps[5];
  }
  if (PWM_VALUES[6] == pwm_count)
  {
    // turn on
    PORTA.OUTSET = pinMaps[6];
  }
  if (PWM_VALUES[7] == pwm_count)
  {
    // turn on
    PORTA.OUTSET = pinMaps[7];
  }

 
  GLOBAL_FLAG = 1;

  //PORTA.OUTTGL =(0b00110000);
  
  TCB0.INTFLAGS = TCB_CAPT_bm;

}


void setPWM(int i, byte newValue)
{
  if (newValue >= PWM_MAX)
  {
    return;
  }
  if (newValue < 0)
  {
    return;
  }
  if(i >= N_PWM)
  {
    return;
  }

  PWM_VALUES[i] = newValue;

  // enable the PWM
  //
  pinMaps[i] = pinTemplates[i];

  
  
}


//Disable PWM and enable normal DIO on the pin
//
void disablePWM(int i)
{
  if(i < 0)
  {
    return;
  }
  if(i > N_PWM)
  {
    return;
  }
   
   PWM_VALUES[i] = 0;
   pinMaps[i] = 0;    
  
}
  


  
