
/*
----------------------------------------------------------------------
1.8.16 IDE

Top16 - II  "AT"   

Operating system
Hardware Version b
Version 1.6


!  Remember to set the Jumper pins when programming, and set back when not programming !

(c) TCTEC Pty Ltd  www.tctec.net



01-Sep-2022   RVW      Version 1.0         Copied from atmega328 version
09-Mar-2023   RVW      Version 1.4         5 second delay on startup, changed LED flash style
18-Mar-2023   RVW      Version 1.5         Comment about clock frequency
17-Jan-2026   RVW      Version 1.6         Command #xX  read digital input, fixed



Settings:

MegaTinyCore
ATTiny806, or ATTimy1606 no bootloader
Clock: 16 MHz internal
* Use 16MHz based clock  (16MHz, 8MHz)
millis/micros enabled (default)
BOD Level 2.6


Important Notes:

! Processor ATTiiny806 at 20MHz, 10MHz, 5MHz is not supported. 

----------------------------------------------------------------------
*/

/* ============================================================================
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
===============================================================================
*/
#include <Wire.h>
#include "ADS1115.h"




#define LED (13)


ADS1115 adc0(ADS1115_DEFAULT_ADDRESS); 

struct GLOBALS {

   int gainSetting ;
   
}globals;


int outputPinMap[8] = {0,1,2,3,4,5,16,15};

const int SERIALBUFSIZE = 16 ;
char  rxBuffer[SERIALBUFSIZE] ;
int rxBufCount = 0 ;
int analogReadings[8] ;

void setupDigitalOutputs()
{
  int count = 0 ;
  
  for(count = 0 ; count < 8; count++)
  {
    pinMode(outputPinMap[count], OUTPUT) ;
  }
}

void processSerial()
{
  char inc ;
  inc = Serial.read() ;
  
  if (inc > -1)
  {              
    
    // command ?
    //
    if ((inc == '\r') || (inc == '\n'))
    {
      processCommand(rxBuffer) ;
      
      rxBuffer[rxBufCount] = 0 ;
           
      // reset the buffer
      //
      rxBufCount = 0 ;
      
    }    
    else
    {
      rxBuffer[rxBufCount] = inc ;     
      rxBufCount++ ;
    
      if (rxBufCount >= SERIALBUFSIZE)
      {
        rxBufCount = 0 ;
      }
    }
  }  
}


void setup_adc()
{
    Wire.begin();  // join I2C bus
    adc0.initialize(); // initialize ADS1115 16 bit A/D chip
    
    //Serial.println("Testing device connections...");
    //Serial.println(adc0.testConnection() ? "ADS1115 connection successful" : "ADS1115 connection failed");
      
    // To get output from this method, you'll need to turn on the 
    //#define ADS1115_SERIAL_DEBUG // in the ADS1115.h file
    adc0.showConfigRegister();
    
    // Set the gain (PGA)
    //
    adc0.setGain(ADS1115_PGA_6P144 );    
    adc0.setRate(ADS1115_RATE_475);
    
    //  continuous sampling
    //
    adc0.setMode(ADS1115_MODE_CONTINUOUS);     
}




void setup() {   

    // !!  Include this delay in custom code    
    delay(5000);  // allow time for programmer before possible serial port initilisation
  
    setupDigitalOutputs() ;

    
    setupTimer();  

    // MUX for analog inputs
    //
    PORTC.DIRSET = 0b00000111;
   
  
    pinMode(A0, OUTPUT) ;
    pinMode(A1, OUTPUT) ;
    pinMode(A2, OUTPUT) ;
    
    // LED
    //
    pinMode(LED, OUTPUT) ;
    digitalWrite(LED, HIGH) ;
    
    digitalWrite(A0, LOW) ;
    digitalWrite(A1, LOW) ;
    digitalWrite(A2, LOW) ;
          
   
    Serial.begin(115200); // initialize serial communication 
    //Serial.begin(38400);
   
    setup_adc();   
    

}




void loop() 
  {    
    static byte outputState = 0x01 ;
    static byte outputCount = 0 ;
    static long loopCount = 0 ;
    
    loopCount++ ;
    
    if (loopCount > 20000)  // ~ 100 mSec
    {
      loopCount = 0 ; 
      digitalWrite(LED, HIGH) ;          
    }    
             
    outputState <<= 1;
    
    outputCount++ ;
    
    if (outputCount >= 8)
    {
      outputCount = 0 ; 
      outputState = 0x01 ;    
    }
    
    //readNextAnalogInput() ;
    
    processSerial();      
  }

  
  
void setDigitalOutputs(byte state, byte mask)
{
  
  int count = 0 ;
  int checkMask = 0x01 ;
  
  // if the mask bit is set, then change the state of the output
  //
  
  for(count = 0 ; count < 8; count++)
  {
    if (checkMask & mask)
    {
      // disable PWM
      //
      disablePWM(count);
      
      if (checkMask & state)
      {
        digitalWrite(outputPinMap[count], HIGH);
      }
      else
      {
        digitalWrite(outputPinMap[count], LOW) ;
      }
    }
    checkMask <<= 1 ;    
  }   
}

/* set the analog Gain (range)

The options are:

#define ADS1115_PGA_6P144           0x00
#define ADS1115_PGA_4P096           0x01
#define ADS1115_PGA_2P048           0x02 
#define ADS1115_PGA_1P024           0x03
#define ADS1115_PGA_0P512           0x04
#define ADS1115_PGA_0P256           0x05
#define ADS1115_PGA_0P256B          0x06
#define ADS1115_PGA_0P256C          0x07

*/
void setGain(uint8_t gain)
{    
    adc0.setGain(gain);  
    globals.gainSetting = gain ;    
}

/*
Continuously read the inputs and update the reading array 
*/
void readNextAnalogInput()
{
  static byte input = 0 ;  
  
  // get sample
  //
  analogReadings[input] = adc0.getConversionP0GND();
  
  input++ ;  
  if (input > 7)
  {
    input = 0 ;
  }
  // set MUX address for next input
  //  
  PORTC.OUTCLR =(0b00000111);
  PORTC.OUTSET = (input) ;
  
   
}

double readAnalogIn(int input)
{ 
  int actualInput = 0 ;
  
  if (input > 8)
  {
    input = 1 ;
  }
  input-- ;
  
  switch (input)
  {
    case 7: actualInput = 0 ; break ;
    case 6: actualInput = 1 ; break ;
    case 5: actualInput = 2 ; break ;
    case 4: actualInput = 3 ; break ;
    case 3: actualInput = 4 ; break ;
    case 2: actualInput = 5 ; break ;
    case 1: actualInput = 6 ; break ;
    case 0: actualInput = 7 ; break ;
    
  }
  
  // set MUX address 
  //    
  PORTC.OUTCLR =(0b00000111);
  PORTC.OUTSET = (actualInput) ;
  
  delay(5) ;     
  
 
  return(adc0.getConversionP0GND()* adc0.getMvPerCount());    
  
}

int readAllDigitalInputs()
{
  int digitalState = 0 ;
  int count = 8 ;
  
  // temporarily set the analog gain to 6.144 Volts
  //  
  setGain(0) ;
  
  // read all the digital inputs
  //
  
  for(count = 8; count > 0; count--)
  {
    // read analog voltages and convert to digital
    //
    if(readAnalogIn(count) > 2500)   // 2.5 volts
    {
      digitalState |= 1 ;
    }
    else
    {      
    }
    digitalState <<= 1;
  }
  
  digitalState >>= 1 ;
  
  // restore gain setting
  //
  setGain(globals.gainSetting) ;  
  
  return(digitalState);  
  
}

int readDigitalInput(int input)
{  
  
  int digitalState = 0 ;    
  
  //Serial.println(readAnalogIn(input));
  // read analog voltages and convert to digital
  //
  if(readAnalogIn(input) > 2500)   // 2.5 volts
  {
    digitalState = 1 ;
  }
  else
  {
    digitalState = 0 ;
  }
  //setGain(globals.gainSetting) ;  
  return(digitalState) ;  
  
}


/*

Valid PWM output pins are:


*/
void SETPWM(int pin, int Value)
{
  byte newValue = Value;

  newValue >>= 1;

  setPWM(pin-1, newValue);
 
  
}
